﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using VeteransAffairs.Registries.BusinessAHOBPR;
namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class BensUpdater : AHOBPRBaseBO
    {
        static bool isTaken;
        string connectionInfo = string.Empty;
        List<UPDATES_PROCESSED_NOTIFICATION_STATUS> entriesProcessedToday;
        readonly AHOBPRShared _sharedManager;
        public BensUpdater(string dbConnInfo)
        {
            connectionInfo = dbConnInfo;
            _sharedManager = new AHOBPRShared();
        }
        public BensUpdater() { }



        UPDATES_PROCESSED_NOTIFICATION_STATUS CreateProcessedNotification(UPDATES_BENS_REGISTRANT_NOTIFICATION entry, string processName, string status, string error)
        {
            var notification = new UPDATES_PROCESSED_NOTIFICATION_STATUS();
            notification.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID = entry.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID;
            notification.REGISTRANT_ID = entry.REGISTRANT_ID;
            notification.EDIPI = entry.EDIPI;
            notification.PROCESS_NAME = processName;
            notification.PROCESS_STATUS = status;
            notification.CREATED = DateTime.Now;
            notification.CREATEDBY = "RegistrantUpdator";
            notification.UPDATED = DateTime.Now;
            notification.UPDATEDBY = "RegistrantUpdator";
            notification.PROCESS_ERROR = error;
            return notification;
        }

        public List<UPDATES_BENS_REGISTRANT_NOTIFICATION> GetAllRegistrantUpdateNotifications()
        {
            var unprocessedNotfications = new List<UPDATES_BENS_REGISTRANT_NOTIFICATION>();
            using (_dbAhobpr = GetLocalContext(connectionInfo))
            {
                unprocessedNotfications = _dbAhobpr.SP_GetPendingRegistrantUpdates().ToList();
            }
            return unprocessedNotfications;
        }


        private void ProcessNotifications(List<IUpdateManager> updateManagers, BensNotifcationsContainer notifications, UPDATES_BENS_REGISTRANT_NOTIFICATION entry)
        {
            var status = string.Empty;
            var error = string.Empty;
            var hasLogEntry = false;
            foreach (IUpdateManager manager in updateManagers)
            {
                if (!entriesProcessedToday.Any(processedNotification => processedNotification.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID == entry.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID
                            && processedNotification.EDIPI == entry.EDIPI
                            && processedNotification.PROCESS_NAME == manager.Name
                            && processedNotification.PROCESS_STATUS != "success"))
                {
                    if (!hasLogEntry)
                    {
                        AHOBPRLogger.LogErrorMessage("INFO", "BensUpdater.ProcessNotifications", $"Attempting to update Registrant ID: {entry.REGISTRANT_ID}");
                        hasLogEntry = true;
                    }
                    status = UpdateBensEntry(notifications, entry, manager);
                    UPDATES_PROCESSED_NOTIFICATION_STATUS notification = CreateProcessedNotification(entry, manager.Name, status, error);
                    notifications.ProcessedNotifications.Add(notification);
                }
            }
        }
        public string ReconcileQueue(List<IUpdateManager> registrantManagers)
        {
            string result = "ReconcileQueue already running";
            if (!isTaken)
            {
                isTaken = true;
                try
                {
                    var notifications = GetAllRegistrantUpdateNotifications();
                    var bensNotifications = new BensNotifcationsContainer(notifications);
                    result = ReconcileQueue(registrantManagers, bensNotifications);
                }
                catch (Exception)
                {
                    result = "error";
                }
                finally
                {
                    isTaken = false;
                }
            }
            return result;
        }
        private string ReconcileQueue(List<IUpdateManager> updateManagers, BensNotifcationsContainer notifications)
        {
            string result = string.Empty;
            if (notifications != null)
            {
                if (notifications.Count > 0)
                {
                    AHOBPRLogger.LogErrorMessage("INFO", "BensUpdater.ReconcileQueue", $"BENS Queue Entries found: {notifications.Count}");
                    UpdateEachEntry(updateManagers, notifications);
                }
                result = "found:" + notifications.Count + ",updated:" + notifications.UpdatedEntries + ",failed:" + notifications.FailedUpdates + ",duplicates:" + notifications.Duplicates;
            }
            return result;
        }

        private void UpdateEachEntry(List<IUpdateManager> updateManagers, BensNotifcationsContainer notifications)
        {
            GetProcessedEntriesFromDB();
            foreach (var entry in notifications.QueueEntries)
            {
                ProcessNotifications(updateManagers, notifications, entry);
                SaveProcessedNotificationStatuses(notifications);
            }
        }

        private void GetProcessedEntriesFromDB()
        {
            //go through the list of updators 
            using (var db = GetLocalContext(connectionInfo))
            {
                entriesProcessedToday = db.UPDATES_PROCESSED_NOTIFICATION_STATUS.Where(u => u.UPDATED.Date <= DateTime.Now.Date.AddDays(-1)).ToList();
            }
        }

        private void SaveProcessedNotificationStatuses(BensNotifcationsContainer notifications)
        {
            if (notifications.ProcessedNotifications.Count > 100)
            {
                foreach (UPDATES_PROCESSED_NOTIFICATION_STATUS entry in notifications.ProcessedNotifications)
                {
                    SaveUpdateNotificationStatus(entry);
                }
                entriesProcessedToday.AddRange(notifications.ProcessedNotifications);
                notifications.ProcessedNotifications = new List<UPDATES_PROCESSED_NOTIFICATION_STATUS>();
            }
        }

        public void SaveUpdateNotificationStatus(UPDATES_PROCESSED_NOTIFICATION_STATUS entry)
        {
            try
            {
                using (_dbAhobpr = GetLocalContext(connectionInfo))
                {
                    _dbAhobpr.SP_InsertIntoUpdatesProcessed(entry.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID,
                        entry.REGISTRANT_ID, entry.EDIPI, entry.PROCESS_NAME, entry.PROCESS_STATUS, entry.PROCESS_ERROR, entry.CREATEDBY);
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
            }
        }
        string UpdateBensEntry(BensNotifcationsContainer notifications, UPDATES_BENS_REGISTRANT_NOTIFICATION bensEntry, IUpdateManager manager)
        {
            string status;
            //If no entrys with this edipi have been processed, then process it
            if (!notifications.ProcessedNotifications.Any(processedNotification => processedNotification.EDIPI == bensEntry.EDIPI && processedNotification.PROCESS_NAME == manager.Name))
            {
                var success = manager.Update(bensEntry.EDIPI, bensEntry.REGISTRANT_ID);
                if (success)
                {
                    status = notifications.IncrementUpdatedEntries();
                }
                else
                {
                    status = notifications.IncrementFailure();
                }
            }
            else //add it to the list as a duplicate, so it won't be picked up for processing by the stored procedure in the future
            {
                status = notifications.IncrementDuplicates();
            }

            return status;
        }

        //public List<UPDATES_BENS_REGISTRANT_NOTIFICATION> GetAllRegistrantUpdateNotificationsByEdipi(string edipi)
        //{
        //    var unprocessedNotfications = new List<UPDATES_BENS_REGISTRANT_NOTIFICATION>();
        //    using (_dbAhobpr = GetLocalContext(connectionInfo))
        //    {
        //        unprocessedNotfications = _dbAhobpr.SP_GetPendingRegistrantUpdates().ToList();
        //    }
        //    return unprocessedNotfications;
        //}

    }
}

